# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

class ApplicationController < ActionController::Base
  helper :all # include all helpers, all the time

  # See ActionController::RequestForgeryProtection for details
  # Uncomment the :secret if you're not using the cookie session store
  protect_from_forgery # :secret => '6a90906a2ef0648059dd99e5d3707eae'

  protected
  def authenticate
    authenticate_or_request_with_http_basic do |name, password|
      @current_user = User.authenticate(name, password)
    end
  end

end
